import java.math.BigInteger;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

import net.catcert.DigitalSignatureServiceStub;

import org.apache.xmlbeans.XmlOptions;
import org.w3.www._2000._09.xmldsig.X509DataDocument;
import org.w3.www._2000._09.xmldsig.X509DataType;

import schema.core._0._1.dss.tc.names.oasis.SignatureObjectType;
import schema.core._0._1.dss.tc.names.oasis.VerifyRequestDocument;
import schema.core._0._1.dss.tc.names.oasis.VerifyResponseDocument;
import schema.core._0._1.dss.tc.names.oasis.OptionalInputsDocument.OptionalInputs;
import schema.core._0._1.dss.tc.names.oasis.SignatureObjectType.Other;
import schema.core._0._1.dss.tc.names.oasis.VerifyRequestDocument.VerifyRequest;
import xss.profiles._0._1.dss.tc.names.oasis.ReturnX509CertificateInfoDocument.ReturnX509CertificateInfo;
import assertion._0._2.saml.tc.names.oasis.AttributeType;

import com.bs.psis.test.utils.ResponseObject;
import com.bs.psis.test.utils.Utils;

/**
 * Valida un certificat
 * 
 * @author Toni Llebaria
 * 
 */
public class ValidacioCertificat {

	/**
	 * @param args
	 * @throws Exception
	 */
	public static void main(String[] args) throws Exception {

		// Configuraci socket TSL
		// Client keystore init
		System.setProperty("javax.net.ssl.keyStore","C:\\psisauth.p12");
		// Here we define the type of keystore jks, pkcs12 or the one containing the user keys
		System.setProperty("javax.net.ssl.keyStoreType","pkcs12");
		// The keystore password
		System.setProperty("javax.net.ssl.keyStorePassword", "sIikZSmz");

		// Cert must be added to cacerts using keytool or specified here
		System.setProperty("javax.net.ssl.trustStore","C:\\Program Files\\Java\\jre1.5.0_14\\lib\\security\\cacerts_pre");
		System.setProperty("javax.net.ssl.trustStoreType", "JKS");
		System.setProperty("javax.net.ssl.trustStorePassord", "changeit");
		//System.setProperty("javax.net.debug", "ssl");

		// Security Provider
		System.setProperty("java.protocol.handler.pkgs","com.sun.net.ssl.internal.www.protocol");
		Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());
		
	
		XmlOptions options = new XmlOptions();

		Map namespacePrefixes = new HashMap();
		namespacePrefixes.put("xss", "urn:oasis:names:tc:dss:1.0:profiles:XSS");
		namespacePrefixes.put("dss", "urn:oasis:names:tc:dss:1.0:core:schema");
		options.setSaveSuggestedPrefixes(namespacePrefixes);

		VerifyRequestDocument requestDocument = VerifyRequestDocument.Factory.newInstance(options);
		VerifyRequest request = requestDocument.addNewVerifyRequest();
		request.setProfile("urn:oasis:names:tc:dss:1.0:profiles:XSS");

		// Creaci de l'element amb el certificat a verificar
		SignatureObjectType signature = request.addNewSignatureObject();

		X509DataDocument x509doc = X509DataDocument.Factory.newInstance();
		X509DataType x509data = x509doc.addNewX509Data();

		byte[] certificate = Utils.readBase64File("cert1.cer");
		x509data.setX509Certificate(certificate);

		Other any = signature.addNewOther();
		any.set(x509doc);

		signature.setOther(any);

		// Creaci de l'element amb els parmetres opcionals a consultar
		OptionalInputs optional = request.addNewOptionalInputs();

		// Detalls del resultat de validaci
		optional.addNewReturnProcessingDetails();
		
		// Execuci del servei
		DigitalSignatureServiceStub digitalSignatureServiceStub = new DigitalSignatureServiceStub("http://psisbeta.catcert.net/psis/catcert-test/dss");
		requestDocument = VerifyRequestDocument.Factory.parse(requestDocument.newInputStream());		
		
		// Visualitzaci de la petici
		System.out.println(requestDocument.xmlText());
		
		VerifyResponseDocument responseDocument = digitalSignatureServiceStub.verify(requestDocument);
		
		// visualitzaci de la resposta
		System.out.println(responseDocument.xmlText());
		
	}
}